' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox. 
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data

''' <summary>
''' Dostarcza metod do pracy z kategoiriami.
''' </summary>
Public Class Category

  ''' <summary>
  ''' Ukryj konstruktor, aby unikn tworzenia egzemplarzy klasy Category.
  ''' </summary>
  Private Sub New()
  End Sub

  ''' <summary>
  ''' Tworzy now kategori w bazie danych. 
  ''' </summary>
  ''' <param name="description">Nazwa nowej kategorii.</param>
  ''' <param name="parentCategoryId">Identyfikator kategorii macierzystej, jeli istnieje, lub liczba mniejsza od 1 dla kategorii gwnej.</param>
  ''' <remarks>Jeli <paramref name="parentCategoryId" /> jest mniejsze ni 1, nowa kategoria jest tworzona na najwyszym poziomie. W przeciwnym wypadku tworzony jest rekord potomny.</remarks>
  Public Shared Sub CreateCategory(ByVal description As String, ByVal parentCategoryId As Integer)
    CategoryDB.CreateCategory(description, parentCategoryId)
  End Sub

  ''' <summary>
  ''' Zwraca identyfikator danej kategorii i wszystkie identyfikatory jej rodzicw, posortowane od rodzica do ostatniego dziecka
  ''' </summary>
  ''' <param name="categoryId">Identyfikator danej kategorii.</param>
  ''' <returns>DataSet z czterema kolumnami:
  ''' <list type="bullet">
  '''  <item>Id</item>
  '''  <item>Description</item>
  '''  <item>ParentCategoryId</item>
  '''  <item>Level</item>
  ''' </list>
  ''' </returns>
  Public Shared Function GetCategoryPath(ByVal categoryId As Integer) As DataSet
    Return CategoryDB.GetCategoryPath(categoryId)
  End Function

  ''' <summary>
  ''' Zwraca list kategorii jako zestaw danych.
  ''' </summary>
  ''' <param name="parentCategoryId">Identyfikator kategorii macierzystej dla ktrej maj by zwrcone kategorie potomne.</param>
  ''' <returns></returns>
  ''' <remarks>Jeli <paramref name="parentCategoryId" /> jest mniejszy od 1, pobierane s wszystkie kategori gwne. W przeciwnym wypadku zwracane s kategorie potomne danej kategorii macierzystej.</remarks>
  Public Shared Function GetCategoryList(ByVal parentCategoryId As Integer) As DataSet
    Return CategoryDB.GetCategoryList(parentCategoryId)
  End Function

End Class
